<?php
$widget->add_render_attribute( 'selected_icon', 'class' );
$has_icon = ! empty( $settings['selected_icon'] );
if ( $has_icon ) {
    $widget->add_render_attribute( 'i', 'class', $settings['selected_icon'] );
    $widget->add_render_attribute( 'i', 'aria-hidden', 'true' );
}

$widget->add_render_attribute( 'description_text', 'class', 'item--description fs-desc-md' );

$widget->add_inline_editing_attributes( 'title_text', 'none' );
$widget->add_inline_editing_attributes( 'description_text' );

$is_new = \Elementor\Icons_Manager::is_migration_allowed();

if ( ! empty( $settings['item_link']['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $settings['item_link']['url'] );

    if ( $settings['item_link']['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $settings['item_link']['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
}
$html_id = ct_get_element_id($settings);
?>
<div id="<?php echo esc_attr($html_id); ?>" class="ct-fancy-box ct-fancy-box-layout1 <?php echo esc_attr($settings['style'].' '.$settings['ct_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
    <div class="ct-inline-css"  data-css="
        <?php if( !empty($settings['hover_gradient_color']) ) : ?>
            #<?php echo esc_attr($html_id) ?>.ct-fancy-box-layout1.style5:before {
                background-image: -webkit-gradient(linear, left top, left bottom, from(rgba(0, 124, 251, 0)), to(<?php echo esc_attr($settings['hover_gradient_color']); ?>));
                background-image: -webkit-linear-gradient(bottom, rgba(0, 124, 251, 0), <?php echo esc_attr($settings['hover_gradient_color']); ?>);
                background-image: -moz-linear-gradient(bottom, rgba(0, 124, 251, 0), <?php echo esc_attr($settings['hover_gradient_color']); ?>);
                background-image: -ms-linear-gradient(bottom, rgba(0, 124, 251, 0), <?php echo esc_attr($settings['hover_gradient_color']); ?>);
                background-image: -o-linear-gradient(bottom, rgba(0, 124, 251, 0), <?php echo esc_attr($settings['hover_gradient_color']); ?>);
                background-image: linear-gradient(bottom, rgba(0, 124, 251, 0), <?php echo esc_attr($settings['hover_gradient_color']); ?>);
                filter: progid:DXImageTransform.Microsoft.gradient(startColorStr='rgba(0, 124, 251, 0)', endColorStr='<?php echo esc_attr($settings['hover_gradient_color']); ?>');
            }
        <?php endif; ?>
        <?php if( !empty($settings['icon_bgcolor']) && !empty($settings['icon_bgcolor_gradient']) ) : ?>
            #<?php echo esc_attr($html_id) ?>.ct-fancy-box-layout1.style6 .item--icon {
                background-image: -webkit-gradient(linear, left top, right top, from(<?php echo esc_attr($settings['icon_bgcolor']); ?>), to(<?php echo esc_attr($settings['icon_bgcolor_gradient']); ?>));
                background-image: -webkit-linear-gradient(left, <?php echo esc_attr($settings['icon_bgcolor']); ?>, <?php echo esc_attr($settings['icon_bgcolor_gradient']); ?>);
                background-image: -moz-linear-gradient(left, <?php echo esc_attr($settings['icon_bgcolor']); ?>, <?php echo esc_attr($settings['icon_bgcolor_gradient']); ?>);
                background-image: -ms-linear-gradient(left, <?php echo esc_attr($settings['icon_bgcolor']); ?>, <?php echo esc_attr($settings['icon_bgcolor_gradient']); ?>);
                background-image: -o-linear-gradient(left, <?php echo esc_attr($settings['icon_bgcolor']); ?>, <?php echo esc_attr($settings['icon_bgcolor_gradient']); ?>);
                background-image: linear-gradient(left, <?php echo esc_attr($settings['icon_bgcolor']); ?>, <?php echo esc_attr($settings['icon_bgcolor_gradient']); ?>);
                filter: progid:DXImageTransform.Microsoft.gradient(startColorStr='<?php echo esc_attr($settings['icon_bgcolor']); ?>', endColorStr='<?php echo esc_attr($settings['icon_bgcolor_gradient']); ?>', gradientType='1');
            }
        <?php endif; ?>
        ">
    </div>

    <?php if ( $settings['icon_type'] == 'icon' && $has_icon ) : ?>
        <div class="item--icon">
            <?php if($is_new):
                \Elementor\Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true' ] );
                else: ?>
                <i <?php ct_print_html($widget->get_render_attribute_string( 'i' )); ?>></i>
            <?php endif; ?>
        </div>
    <?php endif; ?>
    <?php if ( $settings['icon_type'] == 'image' && !empty($settings['icon_image']['id']) ) : ?>
        <div class="item--icon">
            <?php $img_icon  = ct_get_image_by_size( array(
                    'attach_id'  => $settings['icon_image']['id'],
                    'thumb_size' => 'full',
                ) );
                $thumbnail_icon    = $img_icon['thumbnail'];
            echo ct_print_html($thumbnail_icon); ?>
        </div>
    <?php endif; ?>
    <div class="item--holder">
        <h3 class="item--title fs-title-sm <?php echo esc_attr($theme_custom_font); ?>">
            <?php echo ct_print_html($settings['title_text']); ?>
        </h3>
        <div <?php ct_print_html($widget->get_render_attribute_string( 'description_text' )); ?>><?php echo ct_print_html($settings['description_text']); ?></div>
    </div>

    <?php if ( ! empty( $settings['item_link']['url'] ) ) { ?>
        <a class="item--link" <?php ct_print_html($widget->get_render_attribute_string( 'button' )); ?>></a>
    <?php } ?>
</div>